@echo off
setlocal enabledelayedexpansion

:: Error codes
set ERROR_OPENSSL_ENCRYPTION_FAILED=1
set ERROR_OPENSSL_KEY_GENERATION_FAILED=2
set ERROR_OPENSSL_CERT_GENERATION_FAILED=3

:: Call the main script
goto :main

:: Funkce pro zobrazen zprvy o chyb a ukonen skriptu
:error_exit
echo Error: %~1
pause
exit %~2

:: Subroutine to validate user input
:validate_input
set "input=%~1"
if /i "!input!"=="y" (
  set "use_password=true"
  exit /b 0
)
if /i "!input!"=="n" (
  set "use_password=false"
  exit /b 0
)
if "!input!"=="" (
  set "use_password=true"
  exit /b 0
)
exit /b 1

:: Subroutine to validate positive integer
:validate_positive_integer
set "input=%~1"
:: Check if input is a number
echo %input%| findstr /r "^[1-9][0-9]*$">nul
if %errorlevel% equ 0 (
  exit /b 0
) else (
  exit /b 1
)

:validity_len
set "days=365"
set /p "days=Number of days the certificate is valid [365]: "
:: Validate numeric input
call :validate_positive_integer "%days%"
if errorlevel 1 (
  echo This is not a positive number
  goto :validity_len
)
exit /b 0

:get_password_prompt
set "key_file=%~1"
set "passwd="
set /p "passwd=Do you want to set a private key password? [Y/n]: "

:: Validate user input
call :validate_input "%passwd%"
if errorlevel 1 (
  goto :get_password_prompt
)

:encrypt_private_key
:: Display result based on user input
if "!use_password!"=="true" (
  openssl rsa -aes256 -in %key_file% -out %key_file%.encrypted >nul 2>&1

  set RETURN_CODE=!ERRORLEVEL!
  if !RETURN_CODE! == 0 (
    DEL %key_file% >nul 2>&1
    MOVE %key_file%.encrypted %key_file% >nul 2>&1
    echo Private key encrypted successfully.
  ) else (
    set /a openssl_retries+=1
    if !openssl_retries! lss 3 (
      echo retrying...
      goto encrypt_private_key
    ) else (
      call :error_exit "Encryption failed after 3 attempts." %ERROR_OPENSSL_ENCRYPTION_FAILED%
    )    
  )
)
exit /b 0

:: Main script
:main
:: Create CA key
echo Generating key...
openssl genrsa -out client.key 2048

call :validity_len

openssl req -new -key client.key -out client.csr -config openssl.cnf
if errorlevel 1 (
  call :error_exit "Error when generating private key." %ERROR_OPENSSL_KEY_GENERATION_FAILED%
)
openssl x509 -req -in client.csr -CA ca.crt -CAkey ca.key -CAcreateserial -out client.crt -days %days% -sha256 -extfile xpclient.ext -extensions v3_client
if errorlevel 1 (
  call :error_exit "Error when generating certificate." %ERROR_OPENSSL_CERT_GENERATION_FAILED%
)

call :get_password_prompt "client.key"
